package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ProblemType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ProblemType
}
object ProblemType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProblemType
  ): zio.aws.sagemaker.model.ProblemType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProblemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProblemType.BINARY_CLASSIFICATION =>
      val r = BinaryClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.ProblemType.MULTICLASS_CLASSIFICATION =>
      val r = MulticlassClassification
      r
    case software.amazon.awssdk.services.sagemaker.model.ProblemType.REGRESSION =>
      val r = Regression
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProblemType =
      software.amazon.awssdk.services.sagemaker.model.ProblemType.UNKNOWN_TO_SDK_VERSION
  }
  case object BinaryClassification extends zio.aws.sagemaker.model.ProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProblemType =
      software.amazon.awssdk.services.sagemaker.model.ProblemType.BINARY_CLASSIFICATION
  }
  case object MulticlassClassification
      extends zio.aws.sagemaker.model.ProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProblemType =
      software.amazon.awssdk.services.sagemaker.model.ProblemType.MULTICLASS_CLASSIFICATION
  }
  case object Regression extends zio.aws.sagemaker.model.ProblemType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProblemType =
      software.amazon.awssdk.services.sagemaker.model.ProblemType.REGRESSION
  }
}
