package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait FeatureGroupStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus
}
object FeatureGroupStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus
  ): zio.aws.sagemaker.model.FeatureGroupStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATE_FAILED =>
      val r = CreateFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATING
  }
  case object Created extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATED
  }
  case object CreateFailed extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.CREATE_FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.DELETING
  }
  case object DeleteFailed extends zio.aws.sagemaker.model.FeatureGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus.DELETE_FAILED
  }
}
