package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RepositoryAccessMode {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode
}
object RepositoryAccessMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode
  ): zio.aws.sagemaker.model.RepositoryAccessMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.PLATFORM =>
      val r = Platform
      r
    case software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.VPC =>
      val r = Vpc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Platform extends zio.aws.sagemaker.model.RepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.PLATFORM
  }
  case object Vpc extends zio.aws.sagemaker.model.RepositoryAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode =
      software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode.VPC
  }
}
