package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ProvisioningParameterValue,
  ProvisioningParameterKey
}
import scala.jdk.CollectionConverters._
final case class ProvisioningParameter(
    key: Optional[ProvisioningParameterKey] = Optional.Absent,
    value: Optional[ProvisioningParameterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter = {
    import ProvisioningParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter
      .builder()
      .optionallyWith(
        key.map(value =>
          ProvisioningParameterKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        value.map(value =>
          ProvisioningParameterValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly =
    zio.aws.sagemaker.model.ProvisioningParameter.wrap(buildAwsValue())
}
object ProvisioningParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProvisioningParameter =
      zio.aws.sagemaker.model.ProvisioningParameter(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[ProvisioningParameterKey]
    def value: Optional[ProvisioningParameterValue]
    def getKey: ZIO[Any, AwsError, ProvisioningParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ProvisioningParameterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter
  ) extends zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly {
    override val key: Optional[ProvisioningParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ProvisioningParameterKey(value)
      )
    override val value: Optional[ProvisioningParameterValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProvisioningParameterValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter
  ): zio.aws.sagemaker.model.ProvisioningParameter.ReadOnly = new Wrapper(impl)
}
