package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{IdempotencyToken, PipelineName}
import scala.jdk.CollectionConverters._
final case class DeletePipelineRequest(
    pipelineName: PipelineName,
    clientRequestToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .clientRequestToken(
        IdempotencyToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeletePipelineRequest.ReadOnly =
    zio.aws.sagemaker.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeletePipelineRequest =
      zio.aws.sagemaker.model
        .DeletePipelineRequest(pipelineName, clientRequestToken)
    def pipelineName: PipelineName
    def clientRequestToken: IdempotencyToken
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getClientRequestToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest
  ) extends zio.aws.sagemaker.model.DeletePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
    override val clientRequestToken: IdempotencyToken =
      zio.aws.sagemaker.model.primitives
        .IdempotencyToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest
  ): zio.aws.sagemaker.model.DeletePipelineRequest.ReadOnly = new Wrapper(impl)
}
