package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{RoleArn, MonitoringJobDefinitionName}
import scala.jdk.CollectionConverters._
final case class CreateDataQualityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName,
    dataQualityBaselineConfig: Optional[
      zio.aws.sagemaker.model.DataQualityBaselineConfig
    ] = Optional.Absent,
    dataQualityAppSpecification: zio.aws.sagemaker.model.DataQualityAppSpecification,
    dataQualityJobInput: zio.aws.sagemaker.model.DataQualityJobInput,
    dataQualityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Optional[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      Optional.Absent,
    roleArn: RoleArn,
    stoppingCondition: Optional[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest = {
    import CreateDataQualityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .optionallyWith(
        dataQualityBaselineConfig.map(value => value.buildAwsValue())
      )(_.dataQualityBaselineConfig)
      .dataQualityAppSpecification(dataQualityAppSpecification.buildAwsValue())
      .dataQualityJobInput(dataQualityJobInput.buildAwsValue())
      .dataQualityJobOutputConfig(dataQualityJobOutputConfig.buildAwsValue())
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateDataQualityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest =
      zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest(
        jobDefinitionName,
        dataQualityBaselineConfig.map(value => value.asEditable),
        dataQualityAppSpecification.asEditable,
        dataQualityJobInput.asEditable,
        dataQualityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobDefinitionName: MonitoringJobDefinitionName
    def dataQualityBaselineConfig
        : Optional[zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly]
    def dataQualityAppSpecification
        : zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly
    def dataQualityJobInput
        : zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly
    def dataQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Optional[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Optional[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getDataQualityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataQualityBaselineConfig",
      dataQualityBaselineConfig
    )
    def getDataQualityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly
    ] = ZIO.succeed(dataQualityAppSpecification)
    def getDataQualityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly
    ] = ZIO.succeed(dataQualityJobInput)
    def getDataQualityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(dataQualityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val dataQualityBaselineConfig
        : Optional[zio.aws.sagemaker.model.DataQualityBaselineConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataQualityBaselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.DataQualityBaselineConfig.wrap(value)
        )
    override val dataQualityAppSpecification
        : zio.aws.sagemaker.model.DataQualityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.DataQualityAppSpecification
        .wrap(impl.dataQualityAppSpecification())
    override val dataQualityJobInput
        : zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly =
      zio.aws.sagemaker.model.DataQualityJobInput
        .wrap(impl.dataQualityJobInput())
    override val dataQualityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.dataQualityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Optional[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition: Optional[
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingCondition())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
      )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest
  ): zio.aws.sagemaker.model.CreateDataQualityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
