package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  AthenaDatabase,
  S3Uri,
  AthenaWorkGroup,
  AthenaCatalog,
  KmsKeyId,
  AthenaQueryString
}
import scala.jdk.CollectionConverters._
final case class AthenaDatasetDefinition(
    catalog: AthenaCatalog,
    database: AthenaDatabase,
    queryString: AthenaQueryString,
    workGroup: Optional[AthenaWorkGroup] = Optional.Absent,
    outputS3Uri: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    outputFormat: zio.aws.sagemaker.model.AthenaResultFormat,
    outputCompression: Optional[
      zio.aws.sagemaker.model.AthenaResultCompressionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition = {
    import AthenaDatasetDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition
      .builder()
      .catalog(AthenaCatalog.unwrap(catalog): java.lang.String)
      .database(AthenaDatabase.unwrap(database): java.lang.String)
      .queryString(AthenaQueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        workGroup.map(value => AthenaWorkGroup.unwrap(value): java.lang.String)
      )(_.workGroup)
      .outputS3Uri(S3Uri.unwrap(outputS3Uri): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .outputFormat(outputFormat.unwrap)
      .optionallyWith(outputCompression.map(value => value.unwrap))(
        _.outputCompression
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly =
    zio.aws.sagemaker.model.AthenaDatasetDefinition.wrap(buildAwsValue())
}
object AthenaDatasetDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AthenaDatasetDefinition =
      zio.aws.sagemaker.model.AthenaDatasetDefinition(
        catalog,
        database,
        queryString,
        workGroup.map(value => value),
        outputS3Uri,
        kmsKeyId.map(value => value),
        outputFormat,
        outputCompression.map(value => value)
      )
    def catalog: AthenaCatalog
    def database: AthenaDatabase
    def queryString: AthenaQueryString
    def workGroup: Optional[AthenaWorkGroup]
    def outputS3Uri: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def outputFormat: zio.aws.sagemaker.model.AthenaResultFormat
    def outputCompression
        : Optional[zio.aws.sagemaker.model.AthenaResultCompressionType]
    def getCatalog: ZIO[Any, Nothing, AthenaCatalog] = ZIO.succeed(catalog)
    def getDatabase: ZIO[Any, Nothing, AthenaDatabase] = ZIO.succeed(database)
    def getQueryString: ZIO[Any, Nothing, AthenaQueryString] =
      ZIO.succeed(queryString)
    def getWorkGroup: ZIO[Any, AwsError, AthenaWorkGroup] =
      AwsError.unwrapOptionField("workGroup", workGroup)
    def getOutputS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(outputS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutputFormat
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AthenaResultFormat] =
      ZIO.succeed(outputFormat)
    def getOutputCompression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AthenaResultCompressionType
    ] = AwsError.unwrapOptionField("outputCompression", outputCompression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition
  ) extends zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly {
    override val catalog: AthenaCatalog =
      zio.aws.sagemaker.model.primitives.AthenaCatalog(impl.catalog())
    override val database: AthenaDatabase =
      zio.aws.sagemaker.model.primitives.AthenaDatabase(impl.database())
    override val queryString: AthenaQueryString =
      zio.aws.sagemaker.model.primitives.AthenaQueryString(impl.queryString())
    override val workGroup: Optional[AthenaWorkGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.workGroup())
      .map(value => zio.aws.sagemaker.model.primitives.AthenaWorkGroup(value))
    override val outputS3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.outputS3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val outputFormat: zio.aws.sagemaker.model.AthenaResultFormat =
      zio.aws.sagemaker.model.AthenaResultFormat.wrap(impl.outputFormat())
    override val outputCompression
        : Optional[zio.aws.sagemaker.model.AthenaResultCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputCompression())
        .map(value =>
          zio.aws.sagemaker.model.AthenaResultCompressionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition
  ): zio.aws.sagemaker.model.AthenaDatasetDefinition.ReadOnly = new Wrapper(
    impl
  )
}
