package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TrialComponentSourceArn
import scala.jdk.CollectionConverters._
final case class TrialComponentSourceDetail(
    sourceArn: Optional[TrialComponentSourceArn] = Optional.Absent,
    trainingJob: Optional[zio.aws.sagemaker.model.TrainingJob] =
      Optional.Absent,
    processingJob: Optional[zio.aws.sagemaker.model.ProcessingJob] =
      Optional.Absent,
    transformJob: Optional[zio.aws.sagemaker.model.TransformJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail = {
    import TrialComponentSourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          TrialComponentSourceArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(trainingJob.map(value => value.buildAwsValue()))(
        _.trainingJob
      )
      .optionallyWith(processingJob.map(value => value.buildAwsValue()))(
        _.processingJob
      )
      .optionallyWith(transformJob.map(value => value.buildAwsValue()))(
        _.transformJob
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSourceDetail.wrap(buildAwsValue())
}
object TrialComponentSourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSourceDetail =
      zio.aws.sagemaker.model.TrialComponentSourceDetail(
        sourceArn.map(value => value),
        trainingJob.map(value => value.asEditable),
        processingJob.map(value => value.asEditable),
        transformJob.map(value => value.asEditable)
      )
    def sourceArn: Optional[TrialComponentSourceArn]
    def trainingJob: Optional[zio.aws.sagemaker.model.TrainingJob.ReadOnly]
    def processingJob: Optional[zio.aws.sagemaker.model.ProcessingJob.ReadOnly]
    def transformJob: Optional[zio.aws.sagemaker.model.TransformJob.ReadOnly]
    def getSourceArn: ZIO[Any, AwsError, TrialComponentSourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTrainingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      AwsError.unwrapOptionField("trainingJob", trainingJob)
    def getProcessingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingJob.ReadOnly] =
      AwsError.unwrapOptionField("processingJob", processingJob)
    def getTransformJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformJob.ReadOnly] =
      AwsError.unwrapOptionField("transformJob", transformJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ) extends zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly {
    override val sourceArn: Optional[TrialComponentSourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentSourceArn(value)
        )
    override val trainingJob
        : Optional[zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJob())
        .map(value => zio.aws.sagemaker.model.TrainingJob.wrap(value))
    override val processingJob
        : Optional[zio.aws.sagemaker.model.ProcessingJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processingJob())
        .map(value => zio.aws.sagemaker.model.ProcessingJob.wrap(value))
    override val transformJob
        : Optional[zio.aws.sagemaker.model.TransformJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transformJob())
        .map(value => zio.aws.sagemaker.model.TransformJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ): zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly = new Wrapper(
    impl
  )
}
