package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters._
final case class LabelingJobResourceConfig(
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig = {
    import LabelingJobResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig
      .builder()
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobResourceConfig.wrap(buildAwsValue())
}
object LabelingJobResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobResourceConfig =
      zio.aws.sagemaker.model
        .LabelingJobResourceConfig(volumeKmsKeyId.map(value => value))
    def volumeKmsKeyId: Optional[KmsKeyId]
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig
  ) extends zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly {
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig
  ): zio.aws.sagemaker.model.LabelingJobResourceConfig.ReadOnly = new Wrapper(
    impl
  )
}
