package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, PipelineDefinition}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribePipelineDefinitionForExecutionResponse(
    pipelineDefinition: Optional[PipelineDefinition] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse = {
    import DescribePipelineDefinitionForExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
      .builder()
      .optionallyWith(
        pipelineDefinition.map(value =>
          PipelineDefinition.unwrap(value): java.lang.String
        )
      )(_.pipelineDefinition)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
      .wrap(buildAwsValue())
}
object DescribePipelineDefinitionForExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse =
      zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse(
        pipelineDefinition.map(value => value),
        creationTime.map(value => value)
      )
    def pipelineDefinition: Optional[PipelineDefinition]
    def creationTime: Optional[Timestamp]
    def getPipelineDefinition: ZIO[Any, AwsError, PipelineDefinition] =
      AwsError.unwrapOptionField("pipelineDefinition", pipelineDefinition)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ) extends zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly {
    override val pipelineDefinition: Optional[PipelineDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineDefinition())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineDefinition(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse
  ): zio.aws.sagemaker.model.DescribePipelineDefinitionForExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
