package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  AppImageConfigName,
  AppImageConfigArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAppImageConfigResponse(
    appImageConfigArn: Optional[AppImageConfigArn] = Optional.Absent,
    appImageConfigName: Optional[AppImageConfigName] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    kernelGatewayImageConfig: Optional[
      zio.aws.sagemaker.model.KernelGatewayImageConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse = {
    import DescribeAppImageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
      .builder()
      .optionallyWith(
        appImageConfigArn.map(value =>
          AppImageConfigArn.unwrap(value): java.lang.String
        )
      )(_.appImageConfigArn)
      .optionallyWith(
        appImageConfigName.map(value =>
          AppImageConfigName.unwrap(value): java.lang.String
        )
      )(_.appImageConfigName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        kernelGatewayImageConfig.map(value => value.buildAwsValue())
      )(_.kernelGatewayImageConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppImageConfigResponse.wrap(buildAwsValue())
}
object DescribeAppImageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppImageConfigResponse =
      zio.aws.sagemaker.model.DescribeAppImageConfigResponse(
        appImageConfigArn.map(value => value),
        appImageConfigName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        kernelGatewayImageConfig.map(value => value.asEditable)
      )
    def appImageConfigArn: Optional[AppImageConfigArn]
    def appImageConfigName: Optional[AppImageConfigName]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def kernelGatewayImageConfig
        : Optional[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly]
    def getAppImageConfigArn: ZIO[Any, AwsError, AppImageConfigArn] =
      AwsError.unwrapOptionField("appImageConfigArn", appImageConfigArn)
    def getAppImageConfigName: ZIO[Any, AwsError, AppImageConfigName] =
      AwsError.unwrapOptionField("appImageConfigName", appImageConfigName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getKernelGatewayImageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayImageConfig",
      kernelGatewayImageConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly {
    override val appImageConfigArn: Optional[AppImageConfigArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appImageConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AppImageConfigArn(value)
        )
    override val appImageConfigName: Optional[AppImageConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appImageConfigName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AppImageConfigName(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val kernelGatewayImageConfig
        : Optional[zio.aws.sagemaker.model.KernelGatewayImageConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelGatewayImageConfig())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayImageConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse
  ): zio.aws.sagemaker.model.DescribeAppImageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
