package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.VersionedArnOrName
import scala.jdk.CollectionConverters._
final case class DeleteModelPackageRequest(
    modelPackageName: VersionedArnOrName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest = {
    import DeleteModelPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest
      .builder()
      .modelPackageName(
        VersionedArnOrName.unwrap(modelPackageName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteModelPackageRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelPackageRequest.wrap(buildAwsValue())
}
object DeleteModelPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteModelPackageRequest =
      zio.aws.sagemaker.model.DeleteModelPackageRequest(modelPackageName)
    def modelPackageName: VersionedArnOrName
    def getModelPackageName: ZIO[Any, Nothing, VersionedArnOrName] =
      ZIO.succeed(modelPackageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest
  ) extends zio.aws.sagemaker.model.DeleteModelPackageRequest.ReadOnly {
    override val modelPackageName: VersionedArnOrName =
      zio.aws.sagemaker.model.primitives
        .VersionedArnOrName(impl.modelPackageName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest
  ): zio.aws.sagemaker.model.DeleteModelPackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
