package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  LineageGroupArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LineageGroupSummary(
    lineageGroupArn: Optional[LineageGroupArn] = Optional.Absent,
    lineageGroupName: Optional[ExperimentEntityName] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary = {
    import LineageGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
      .builder()
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .optionallyWith(
        lineageGroupName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.lineageGroupName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly =
    zio.aws.sagemaker.model.LineageGroupSummary.wrap(buildAwsValue())
}
object LineageGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LineageGroupSummary =
      zio.aws.sagemaker.model.LineageGroupSummary(
        lineageGroupArn.map(value => value),
        lineageGroupName.map(value => value),
        displayName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def lineageGroupArn: Optional[LineageGroupArn]
    def lineageGroupName: Optional[ExperimentEntityName]
    def displayName: Optional[ExperimentEntityName]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
    def getLineageGroupName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("lineageGroupName", lineageGroupName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ) extends zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly {
    override val lineageGroupArn: Optional[LineageGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
    override val lineageGroupName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary
  ): zio.aws.sagemaker.model.LineageGroupSummary.ReadOnly = new Wrapper(impl)
}
