package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters._
final case class EdgeOutputConfig(
    s3OutputLocation: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    presetDeploymentType: Optional[
      zio.aws.sagemaker.model.EdgePresetDeploymentType
    ] = Optional.Absent,
    presetDeploymentConfig: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig = {
    import EdgeOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig
      .builder()
      .s3OutputLocation(S3Uri.unwrap(s3OutputLocation): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(presetDeploymentType.map(value => value.unwrap))(
        _.presetDeploymentType
      )
      .optionallyWith(
        presetDeploymentConfig.map(value => value: java.lang.String)
      )(_.presetDeploymentConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.EdgeOutputConfig.wrap(buildAwsValue())
}
object EdgeOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeOutputConfig =
      zio.aws.sagemaker.model.EdgeOutputConfig(
        s3OutputLocation,
        kmsKeyId.map(value => value),
        presetDeploymentType.map(value => value),
        presetDeploymentConfig.map(value => value)
      )
    def s3OutputLocation: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def presetDeploymentType
        : Optional[zio.aws.sagemaker.model.EdgePresetDeploymentType]
    def presetDeploymentConfig: Optional[String]
    def getS3OutputLocation: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(s3OutputLocation)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPresetDeploymentType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EdgePresetDeploymentType] =
      AwsError.unwrapOptionField("presetDeploymentType", presetDeploymentType)
    def getPresetDeploymentConfig: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("presetDeploymentConfig", presetDeploymentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig
  ) extends zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly {
    override val s3OutputLocation: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputLocation())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val presetDeploymentType
        : Optional[zio.aws.sagemaker.model.EdgePresetDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presetDeploymentType())
        .map(value =>
          zio.aws.sagemaker.model.EdgePresetDeploymentType.wrap(value)
        )
    override val presetDeploymentConfig: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presetDeploymentConfig())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig
  ): zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly = new Wrapper(impl)
}
