package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  FailureReason,
  ImageArn,
  ImageBaseImage,
  ImageContainerImage,
  ImageVersionNumber,
  ImageVersionArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeImageVersionResponse(
    baseImage: Optional[ImageBaseImage] = Optional.Absent,
    containerImage: Optional[ImageContainerImage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    imageArn: Optional[ImageArn] = Optional.Absent,
    imageVersionArn: Optional[ImageVersionArn] = Optional.Absent,
    imageVersionStatus: Optional[zio.aws.sagemaker.model.ImageVersionStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    version: Optional[ImageVersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse = {
    import DescribeImageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
      .builder()
      .optionallyWith(
        baseImage.map(value => ImageBaseImage.unwrap(value): java.lang.String)
      )(_.baseImage)
      .optionallyWith(
        containerImage.map(value =>
          ImageContainerImage.unwrap(value): java.lang.String
        )
      )(_.containerImage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        imageVersionArn.map(value =>
          ImageVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageVersionArn)
      .optionallyWith(imageVersionStatus.map(value => value.unwrap))(
        _.imageVersionStatus
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageVersionResponse.wrap(buildAwsValue())
}
object DescribeImageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageVersionResponse =
      zio.aws.sagemaker.model.DescribeImageVersionResponse(
        baseImage.map(value => value),
        containerImage.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        imageArn.map(value => value),
        imageVersionArn.map(value => value),
        imageVersionStatus.map(value => value),
        lastModifiedTime.map(value => value),
        version.map(value => value)
      )
    def baseImage: Optional[ImageBaseImage]
    def containerImage: Optional[ImageContainerImage]
    def creationTime: Optional[Timestamp]
    def failureReason: Optional[FailureReason]
    def imageArn: Optional[ImageArn]
    def imageVersionArn: Optional[ImageVersionArn]
    def imageVersionStatus: Optional[zio.aws.sagemaker.model.ImageVersionStatus]
    def lastModifiedTime: Optional[Timestamp]
    def version: Optional[ImageVersionNumber]
    def getBaseImage: ZIO[Any, AwsError, ImageBaseImage] =
      AwsError.unwrapOptionField("baseImage", baseImage)
    def getContainerImage: ZIO[Any, AwsError, ImageContainerImage] =
      AwsError.unwrapOptionField("containerImage", containerImage)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getImageVersionArn: ZIO[Any, AwsError, ImageVersionArn] =
      AwsError.unwrapOptionField("imageVersionArn", imageVersionArn)
    def getImageVersionStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageVersionStatus] =
      AwsError.unwrapOptionField("imageVersionStatus", imageVersionStatus)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ) extends zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly {
    override val baseImage: Optional[ImageBaseImage] = zio.aws.core.internal
      .optionalFromNullable(impl.baseImage())
      .map(value => zio.aws.sagemaker.model.primitives.ImageBaseImage(value))
    override val containerImage: Optional[ImageContainerImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerImage())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ImageContainerImage(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: Optional[ImageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
    override val imageVersionArn: Optional[ImageVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionArn())
        .map(value => zio.aws.sagemaker.model.primitives.ImageVersionArn(value))
    override val imageVersionStatus
        : Optional[zio.aws.sagemaker.model.ImageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionStatus())
        .map(value => zio.aws.sagemaker.model.ImageVersionStatus.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val version: Optional[ImageVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ): zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly =
    new Wrapper(impl)
}
