package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLJobObjectiveType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType
}
object AutoMLJobObjectiveType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType
  ): zio.aws.sagemaker.model.AutoMLJobObjectiveType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.MAXIMIZE =>
      val r = Maximize
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.MINIMIZE =>
      val r = Minimize
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.UNKNOWN_TO_SDK_VERSION
  }
  case object Maximize extends zio.aws.sagemaker.model.AutoMLJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.MAXIMIZE
  }
  case object Minimize extends zio.aws.sagemaker.model.AutoMLJobObjectiveType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjectiveType.MINIMIZE
  }
}
