package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RedshiftResultCompressionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType
}
object RedshiftResultCompressionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType
  ): zio.aws.sagemaker.model.RedshiftResultCompressionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.BZIP2 =>
      val r = BZIP2
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.ZSTD =>
      val r = ZSTD
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.SNAPPY =>
      val r = SNAPPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object None
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.NONE
  }
  case object GZIP
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.GZIP
  }
  case object BZIP2
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.BZIP2
  }
  case object ZSTD
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.ZSTD
  }
  case object SNAPPY
      extends zio.aws.sagemaker.model.RedshiftResultCompressionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultCompressionType.SNAPPY
  }
}
