package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ModelNameContains,
  MaxResults,
  PaginationToken
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelsRequest(
    sortBy: Optional[zio.aws.sagemaker.model.ModelSortKey] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.OrderKey] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[ModelNameContains] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelsRequest = {
    import ListModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value =>
          ModelNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelsRequest.wrap(buildAwsValue())
}
object ListModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelsRequest =
      zio.aws.sagemaker.model.ListModelsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value)
      )
    def sortBy: Optional[zio.aws.sagemaker.model.ModelSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.OrderKey]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[ModelNameContains]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.OrderKey] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, ModelNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelsRequest
  ) extends zio.aws.sagemaker.model.ListModelsRequest.ReadOnly {
    override val sortBy: Optional[zio.aws.sagemaker.model.ModelSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ModelSortKey.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.OrderKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.OrderKey.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[ModelNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ModelNameContains(value)
        )
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelsRequest
  ): zio.aws.sagemaker.model.ListModelsRequest.ReadOnly = new Wrapper(impl)
}
