package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HyperParameterTuningJobConfig(
    strategy: zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType,
    hyperParameterTuningJobObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective
    ] = Optional.Absent,
    resourceLimits: zio.aws.sagemaker.model.ResourceLimits,
    parameterRanges: Optional[zio.aws.sagemaker.model.ParameterRanges] =
      Optional.Absent,
    trainingJobEarlyStoppingType: Optional[
      zio.aws.sagemaker.model.TrainingJobEarlyStoppingType
    ] = Optional.Absent,
    tuningJobCompletionCriteria: Optional[
      zio.aws.sagemaker.model.TuningJobCompletionCriteria
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig = {
    import HyperParameterTuningJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig
      .builder()
      .strategy(strategy.unwrap)
      .optionallyWith(
        hyperParameterTuningJobObjective.map(value => value.buildAwsValue())
      )(_.hyperParameterTuningJobObjective)
      .resourceLimits(resourceLimits.buildAwsValue())
      .optionallyWith(parameterRanges.map(value => value.buildAwsValue()))(
        _.parameterRanges
      )
      .optionallyWith(trainingJobEarlyStoppingType.map(value => value.unwrap))(
        _.trainingJobEarlyStoppingType
      )
      .optionallyWith(
        tuningJobCompletionCriteria.map(value => value.buildAwsValue())
      )(_.tuningJobCompletionCriteria)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobConfig.wrap(buildAwsValue())
}
object HyperParameterTuningJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterTuningJobConfig =
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig(
        strategy,
        hyperParameterTuningJobObjective.map(value => value.asEditable),
        resourceLimits.asEditable,
        parameterRanges.map(value => value.asEditable),
        trainingJobEarlyStoppingType.map(value => value),
        tuningJobCompletionCriteria.map(value => value.asEditable)
      )
    def strategy: zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
    def hyperParameterTuningJobObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ]
    def resourceLimits: zio.aws.sagemaker.model.ResourceLimits.ReadOnly
    def parameterRanges
        : Optional[zio.aws.sagemaker.model.ParameterRanges.ReadOnly]
    def trainingJobEarlyStoppingType
        : Optional[zio.aws.sagemaker.model.TrainingJobEarlyStoppingType]
    def tuningJobCompletionCriteria
        : Optional[zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly]
    def getStrategy: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
    ] = ZIO.succeed(strategy)
    def getHyperParameterTuningJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hyperParameterTuningJobObjective",
      hyperParameterTuningJobObjective
    )
    def getResourceLimits
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceLimits.ReadOnly] =
      ZIO.succeed(resourceLimits)
    def getParameterRanges
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ParameterRanges.ReadOnly] =
      AwsError.unwrapOptionField("parameterRanges", parameterRanges)
    def getTrainingJobEarlyStoppingType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrainingJobEarlyStoppingType
    ] = AwsError.unwrapOptionField(
      "trainingJobEarlyStoppingType",
      trainingJobEarlyStoppingType
    )
    def getTuningJobCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tuningJobCompletionCriteria",
      tuningJobCompletionCriteria
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly {
    override val strategy
        : zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType =
      zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType
        .wrap(impl.strategy())
    override val hyperParameterTuningJobObjective: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hyperParameterTuningJobObjective())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobObjective.wrap(value)
      )
    override val resourceLimits
        : zio.aws.sagemaker.model.ResourceLimits.ReadOnly =
      zio.aws.sagemaker.model.ResourceLimits.wrap(impl.resourceLimits())
    override val parameterRanges
        : Optional[zio.aws.sagemaker.model.ParameterRanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterRanges())
        .map(value => zio.aws.sagemaker.model.ParameterRanges.wrap(value))
    override val trainingJobEarlyStoppingType
        : Optional[zio.aws.sagemaker.model.TrainingJobEarlyStoppingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJobEarlyStoppingType())
        .map(value =>
          zio.aws.sagemaker.model.TrainingJobEarlyStoppingType.wrap(value)
        )
    override val tuningJobCompletionCriteria: Optional[
      zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tuningJobCompletionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.TuningJobCompletionCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig
  ): zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly =
    new Wrapper(impl)
}
