package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DomainStatus
  ): zio.aws.sagemaker.model.DomainStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.UPDATE_FAILED =>
      val r = Update_Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.DomainStatus.DELETE_FAILED =>
      val r = Delete_Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Deleting extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.FAILED
  }
  case object InService extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.IN_SERVICE
  }
  case object Pending extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.PENDING
  }
  case object Updating extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.UPDATING
  }
  case object Update_Failed extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.UPDATE_FAILED
  }
  case object Delete_Failed extends zio.aws.sagemaker.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DomainStatus =
      software.amazon.awssdk.services.sagemaker.model.DomainStatus.DELETE_FAILED
  }
}
