package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ArnOrName
import scala.jdk.CollectionConverters._
final case class DescribeModelPackageGroupRequest(
    modelPackageGroupName: ArnOrName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest = {
    import DescribeModelPackageGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest
      .builder()
      .modelPackageGroupName(
        ArnOrName.unwrap(modelPackageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelPackageGroupRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelPackageGroupRequest
      .wrap(buildAwsValue())
}
object DescribeModelPackageGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelPackageGroupRequest =
      zio.aws.sagemaker.model
        .DescribeModelPackageGroupRequest(modelPackageGroupName)
    def modelPackageGroupName: ArnOrName
    def getModelPackageGroupName: ZIO[Any, Nothing, ArnOrName] =
      ZIO.succeed(modelPackageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest
  ) extends zio.aws.sagemaker.model.DescribeModelPackageGroupRequest.ReadOnly {
    override val modelPackageGroupName: ArnOrName =
      zio.aws.sagemaker.model.primitives.ArnOrName(impl.modelPackageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest
  ): zio.aws.sagemaker.model.DescribeModelPackageGroupRequest.ReadOnly =
    new Wrapper(impl)
}
