package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SortOrder
  ): zio.aws.sagemaker.model.SortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.SortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortOrder =
      software.amazon.awssdk.services.sagemaker.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortOrder =
      software.amazon.awssdk.services.sagemaker.model.SortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortOrder =
      software.amazon.awssdk.services.sagemaker.model.SortOrder.DESCENDING
  }
}
