package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{OidcEndpoint, ClientSecret, ClientId}
import scala.jdk.CollectionConverters._
final case class OidcConfig(
    clientId: ClientId,
    clientSecret: ClientSecret,
    issuer: OidcEndpoint,
    authorizationEndpoint: OidcEndpoint,
    tokenEndpoint: OidcEndpoint,
    userInfoEndpoint: OidcEndpoint,
    logoutEndpoint: OidcEndpoint,
    jwksUri: OidcEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OidcConfig = {
    import OidcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OidcConfig
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .issuer(OidcEndpoint.unwrap(issuer): java.lang.String)
      .authorizationEndpoint(
        OidcEndpoint.unwrap(authorizationEndpoint): java.lang.String
      )
      .tokenEndpoint(OidcEndpoint.unwrap(tokenEndpoint): java.lang.String)
      .userInfoEndpoint(OidcEndpoint.unwrap(userInfoEndpoint): java.lang.String)
      .logoutEndpoint(OidcEndpoint.unwrap(logoutEndpoint): java.lang.String)
      .jwksUri(OidcEndpoint.unwrap(jwksUri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OidcConfig.ReadOnly =
    zio.aws.sagemaker.model.OidcConfig.wrap(buildAwsValue())
}
object OidcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OidcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OidcConfig =
      zio.aws.sagemaker.model.OidcConfig(
        clientId,
        clientSecret,
        issuer,
        authorizationEndpoint,
        tokenEndpoint,
        userInfoEndpoint,
        logoutEndpoint,
        jwksUri
      )
    def clientId: ClientId
    def clientSecret: ClientSecret
    def issuer: OidcEndpoint
    def authorizationEndpoint: OidcEndpoint
    def tokenEndpoint: OidcEndpoint
    def userInfoEndpoint: OidcEndpoint
    def logoutEndpoint: OidcEndpoint
    def jwksUri: OidcEndpoint
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getIssuer: ZIO[Any, Nothing, OidcEndpoint] = ZIO.succeed(issuer)
    def getAuthorizationEndpoint: ZIO[Any, Nothing, OidcEndpoint] =
      ZIO.succeed(authorizationEndpoint)
    def getTokenEndpoint: ZIO[Any, Nothing, OidcEndpoint] =
      ZIO.succeed(tokenEndpoint)
    def getUserInfoEndpoint: ZIO[Any, Nothing, OidcEndpoint] =
      ZIO.succeed(userInfoEndpoint)
    def getLogoutEndpoint: ZIO[Any, Nothing, OidcEndpoint] =
      ZIO.succeed(logoutEndpoint)
    def getJwksUri: ZIO[Any, Nothing, OidcEndpoint] = ZIO.succeed(jwksUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfig
  ) extends zio.aws.sagemaker.model.OidcConfig.ReadOnly {
    override val clientId: ClientId =
      zio.aws.sagemaker.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.sagemaker.model.primitives.ClientSecret(impl.clientSecret())
    override val issuer: OidcEndpoint =
      zio.aws.sagemaker.model.primitives.OidcEndpoint(impl.issuer())
    override val authorizationEndpoint: OidcEndpoint =
      zio.aws.sagemaker.model.primitives
        .OidcEndpoint(impl.authorizationEndpoint())
    override val tokenEndpoint: OidcEndpoint =
      zio.aws.sagemaker.model.primitives.OidcEndpoint(impl.tokenEndpoint())
    override val userInfoEndpoint: OidcEndpoint =
      zio.aws.sagemaker.model.primitives.OidcEndpoint(impl.userInfoEndpoint())
    override val logoutEndpoint: OidcEndpoint =
      zio.aws.sagemaker.model.primitives.OidcEndpoint(impl.logoutEndpoint())
    override val jwksUri: OidcEndpoint =
      zio.aws.sagemaker.model.primitives.OidcEndpoint(impl.jwksUri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OidcConfig
  ): zio.aws.sagemaker.model.OidcConfig.ReadOnly = new Wrapper(impl)
}
