package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.DataInputConfig
import scala.jdk.CollectionConverters._
final case class ModelInput(dataInputConfig: DataInputConfig) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelInput = {
    import ModelInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelInput
      .builder()
      .dataInputConfig(
        DataInputConfig.unwrap(dataInputConfig): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelInput.ReadOnly =
    zio.aws.sagemaker.model.ModelInput.wrap(buildAwsValue())
}
object ModelInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelInput =
      zio.aws.sagemaker.model.ModelInput(dataInputConfig)
    def dataInputConfig: DataInputConfig
    def getDataInputConfig: ZIO[Any, Nothing, DataInputConfig] =
      ZIO.succeed(dataInputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelInput
  ) extends zio.aws.sagemaker.model.ModelInput.ReadOnly {
    override val dataInputConfig: DataInputConfig =
      zio.aws.sagemaker.model.primitives.DataInputConfig(impl.dataInputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelInput
  ): zio.aws.sagemaker.model.ModelInput.ReadOnly = new Wrapper(impl)
}
