package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  AppImageConfigName,
  NextToken,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAppImageConfigsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    nameContains: Optional[AppImageConfigName] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    modifiedTimeBefore: Optional[Timestamp] = Optional.Absent,
    modifiedTimeAfter: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.AppImageConfigSortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest = {
    import ListAppImageConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        nameContains.map(value =>
          AppImageConfigName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        modifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeBefore)
      .optionallyWith(
        modifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeAfter)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAppImageConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAppImageConfigsRequest.wrap(buildAwsValue())
}
object ListAppImageConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAppImageConfigsRequest =
      zio.aws.sagemaker.model.ListAppImageConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        modifiedTimeBefore.map(value => value),
        modifiedTimeAfter.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def nameContains: Optional[AppImageConfigName]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def modifiedTimeBefore: Optional[Timestamp]
    def modifiedTimeAfter: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.AppImageConfigSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNameContains: ZIO[Any, AwsError, AppImageConfigName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeBefore", modifiedTimeBefore)
    def getModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeAfter", modifiedTimeAfter)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AppImageConfigSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest
  ) extends zio.aws.sagemaker.model.ListAppImageConfigsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val nameContains: Optional[AppImageConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AppImageConfigName(value)
        )
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.AppImageConfigSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.AppImageConfigSortKey.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest
  ): zio.aws.sagemaker.model.ListAppImageConfigsRequest.ReadOnly = new Wrapper(
    impl
  )
}
