package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ImageStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ImageStatus
}
object ImageStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageStatus
  ): zio.aws.sagemaker.model.ImageStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATING
  }
  case object CREATED extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATED
  }
  case object CREATE_FAILED extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.CREATE_FAILED
  }
  case object UPDATING extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.UPDATING
  }
  case object UPDATE_FAILED extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.UPDATE_FAILED
  }
  case object DELETING extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.DELETING
  }
  case object DELETE_FAILED extends zio.aws.sagemaker.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageStatus =
      software.amazon.awssdk.services.sagemaker.model.ImageStatus.DELETE_FAILED
  }
}
