package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ImageSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ImageSortBy
}
object ImageSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ImageSortBy
  ): zio.aws.sagemaker.model.ImageSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.ImageSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageSortBy.CREATION_TIME =>
      val r = CREATION_TIME
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageSortBy.LAST_MODIFIED_TIME =>
      val r = LAST_MODIFIED_TIME
      r
    case software.amazon.awssdk.services.sagemaker.model.ImageSortBy.IMAGE_NAME =>
      val r = IMAGE_NAME
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ImageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATION_TIME extends zio.aws.sagemaker.model.ImageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageSortBy.CREATION_TIME
  }
  case object LAST_MODIFIED_TIME extends zio.aws.sagemaker.model.ImageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageSortBy.LAST_MODIFIED_TIME
  }
  case object IMAGE_NAME extends zio.aws.sagemaker.model.ImageSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ImageSortBy =
      software.amazon.awssdk.services.sagemaker.model.ImageSortBy.IMAGE_NAME
  }
}
