package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  CreationTime,
  RoleArn,
  SecurityGroupId,
  NetworkInterfaceId,
  FailureReason,
  NotebookInstanceVolumeSizeInGB,
  LastModifiedTime,
  NotebookInstanceArn,
  NotebookInstanceUrl,
  NotebookInstanceName,
  KmsKeyId,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName,
  PlatformIdentifier
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNotebookInstanceResponse(
    notebookInstanceArn: Optional[NotebookInstanceArn] = Optional.Absent,
    notebookInstanceName: Optional[NotebookInstanceName] = Optional.Absent,
    notebookInstanceStatus: Optional[
      zio.aws.sagemaker.model.NotebookInstanceStatus
    ] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    url: Optional[NotebookInstanceUrl] = Optional.Absent,
    instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    notebookInstanceLifecycleConfigName: Optional[
      NotebookInstanceLifecycleConfigName
    ] = Optional.Absent,
    directInternetAccess: Optional[
      zio.aws.sagemaker.model.DirectInternetAccess
    ] = Optional.Absent,
    volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] = Optional.Absent,
    acceleratorTypes: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = Optional.Absent,
    defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] = Optional.Absent,
    additionalCodeRepositories: Optional[Iterable[CodeRepositoryNameOrUrl]] =
      Optional.Absent,
    rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] = Optional.Absent,
    platformIdentifier: Optional[PlatformIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse = {
    import DescribeNotebookInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
      .builder()
      .optionallyWith(
        notebookInstanceArn.map(value =>
          NotebookInstanceArn.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceArn)
      .optionallyWith(
        notebookInstanceName.map(value =>
          NotebookInstanceName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceName)
      .optionallyWith(notebookInstanceStatus.map(value => value.unwrap))(
        _.notebookInstanceStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        url.map(value => NotebookInstanceUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(directInternetAccess.map(value => value.unwrap))(
        _.directInternetAccess
      )
      .optionallyWith(
        volumeSizeInGB.map(value =>
          NotebookInstanceVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .optionallyWith(rootAccess.map(value => value.unwrap))(_.rootAccess)
      .optionallyWith(
        platformIdentifier.map(value =>
          PlatformIdentifier.unwrap(value): java.lang.String
        )
      )(_.platformIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceResponse
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeNotebookInstanceResponse =
      zio.aws.sagemaker.model.DescribeNotebookInstanceResponse(
        notebookInstanceArn.map(value => value),
        notebookInstanceName.map(value => value),
        notebookInstanceStatus.map(value => value),
        failureReason.map(value => value),
        url.map(value => value),
        instanceType.map(value => value),
        subnetId.map(value => value),
        securityGroups.map(value => value),
        roleArn.map(value => value),
        kmsKeyId.map(value => value),
        networkInterfaceId.map(value => value),
        lastModifiedTime.map(value => value),
        creationTime.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        directInternetAccess.map(value => value),
        volumeSizeInGB.map(value => value),
        acceleratorTypes.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value),
        rootAccess.map(value => value),
        platformIdentifier.map(value => value)
      )
    def notebookInstanceArn: Optional[NotebookInstanceArn]
    def notebookInstanceName: Optional[NotebookInstanceName]
    def notebookInstanceStatus
        : Optional[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def failureReason: Optional[FailureReason]
    def url: Optional[NotebookInstanceUrl]
    def instanceType: Optional[zio.aws.sagemaker.model.InstanceType]
    def subnetId: Optional[SubnetId]
    def securityGroups: Optional[List[SecurityGroupId]]
    def roleArn: Optional[RoleArn]
    def kmsKeyId: Optional[KmsKeyId]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def lastModifiedTime: Optional[LastModifiedTime]
    def creationTime: Optional[CreationTime]
    def notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName]
    def directInternetAccess
        : Optional[zio.aws.sagemaker.model.DirectInternetAccess]
    def volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB]
    def acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ]
    def defaultCodeRepository: Optional[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Optional[List[CodeRepositoryNameOrUrl]]
    def rootAccess: Optional[zio.aws.sagemaker.model.RootAccess]
    def platformIdentifier: Optional[PlatformIdentifier]
    def getNotebookInstanceArn: ZIO[Any, AwsError, NotebookInstanceArn] =
      AwsError.unwrapOptionField("notebookInstanceArn", notebookInstanceArn)
    def getNotebookInstanceName: ZIO[Any, AwsError, NotebookInstanceName] =
      AwsError.unwrapOptionField("notebookInstanceName", notebookInstanceName)
    def getNotebookInstanceStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField(
        "notebookInstanceStatus",
        notebookInstanceStatus
      )
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getUrl: ZIO[Any, AwsError, NotebookInstanceUrl] =
      AwsError.unwrapOptionField("url", url)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getDirectInternetAccess
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DirectInternetAccess] =
      AwsError.unwrapOptionField("directInternetAccess", directInternetAccess)
    def getVolumeSizeInGB: ZIO[Any, AwsError, NotebookInstanceVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceAcceleratorType
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
    def getRootAccess: ZIO[Any, AwsError, zio.aws.sagemaker.model.RootAccess] =
      AwsError.unwrapOptionField("rootAccess", rootAccess)
    def getPlatformIdentifier: ZIO[Any, AwsError, PlatformIdentifier] =
      AwsError.unwrapOptionField("platformIdentifier", platformIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly {
    override val notebookInstanceArn: Optional[NotebookInstanceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NotebookInstanceArn(value)
        )
    override val notebookInstanceName: Optional[NotebookInstanceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NotebookInstanceName(value)
        )
    override val notebookInstanceStatus
        : Optional[zio.aws.sagemaker.model.NotebookInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceStatus())
        .map(value =>
          zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value)
        )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val url: Optional[NotebookInstanceUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceUrl(value)
      )
    override val instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.sagemaker.model.primitives.SubnetId(value))
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NetworkInterfaceId(value)
        )
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val directInternetAccess
        : Optional[zio.aws.sagemaker.model.DirectInternetAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directInternetAccess())
        .map(value => zio.aws.sagemaker.model.DirectInternetAccess.wrap(value))
    override val volumeSizeInGB: Optional[NotebookInstanceVolumeSizeInGB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSizeInGB())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .NotebookInstanceVolumeSizeInGB(value)
        )
    override val acceleratorTypes: Optional[
      List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceAcceleratorType.wrap(item)
        }.toList
      )
    override val defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCodeRepository())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
        )
    override val additionalCodeRepositories
        : Optional[List[CodeRepositoryNameOrUrl]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
    override val rootAccess: Optional[zio.aws.sagemaker.model.RootAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootAccess())
        .map(value => zio.aws.sagemaker.model.RootAccess.wrap(value))
    override val platformIdentifier: Optional[PlatformIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformIdentifier())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PlatformIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
