package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLMetricEnum {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum
}
object AutoMLMetricEnum {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum
  ): zio.aws.sagemaker.model.AutoMLMetricEnum = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.ACCURACY =>
      val r = Accuracy
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MSE =>
      val r = MSE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1 =>
      val r = F1
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1_MACRO =>
      val r = F1macro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.AUC =>
      val r = AUC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object Accuracy extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.ACCURACY
  }
  case object MSE extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MSE
  }
  case object F1 extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1
  }
  case object F1macro extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1_MACRO
  }
  case object AUC extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.AUC
  }
}
