package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrialComponentArn,
  ExperimentEntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TrialComponentSimpleSummary(
    trialComponentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    trialComponentSource: Optional[
      zio.aws.sagemaker.model.TrialComponentSource
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary = {
    import TrialComponentSimpleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary
      .builder()
      .optionallyWith(
        trialComponentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentName)
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(trialComponentSource.map(value => value.buildAwsValue()))(
        _.trialComponentSource
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSimpleSummary.wrap(buildAwsValue())
}
object TrialComponentSimpleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSimpleSummary =
      zio.aws.sagemaker.model.TrialComponentSimpleSummary(
        trialComponentName.map(value => value),
        trialComponentArn.map(value => value),
        trialComponentSource.map(value => value.asEditable),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable)
      )
    def trialComponentName: Optional[ExperimentEntityName]
    def trialComponentArn: Optional[TrialComponentArn]
    def trialComponentSource
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getTrialComponentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialComponentName", trialComponentName)
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getTrialComponentSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSource.ReadOnly
    ] = AwsError.unwrapOptionField("trialComponentSource", trialComponentSource)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary
  ) extends zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly {
    override val trialComponentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val trialComponentSource
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentSource())
        .map(value => zio.aws.sagemaker.model.TrialComponentSource.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary
  ): zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly = new Wrapper(
    impl
  )
}
