package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchRecord(
    trainingJob: Optional[zio.aws.sagemaker.model.TrainingJob] =
      Optional.Absent,
    experiment: Optional[zio.aws.sagemaker.model.Experiment] = Optional.Absent,
    trial: Optional[zio.aws.sagemaker.model.Trial] = Optional.Absent,
    trialComponent: Optional[zio.aws.sagemaker.model.TrialComponent] =
      Optional.Absent,
    endpoint: Optional[zio.aws.sagemaker.model.Endpoint] = Optional.Absent,
    modelPackage: Optional[zio.aws.sagemaker.model.ModelPackage] =
      Optional.Absent,
    modelPackageGroup: Optional[zio.aws.sagemaker.model.ModelPackageGroup] =
      Optional.Absent,
    pipeline: Optional[zio.aws.sagemaker.model.Pipeline] = Optional.Absent,
    pipelineExecution: Optional[zio.aws.sagemaker.model.PipelineExecution] =
      Optional.Absent,
    featureGroup: Optional[zio.aws.sagemaker.model.FeatureGroup] =
      Optional.Absent,
    project: Optional[zio.aws.sagemaker.model.Project] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchRecord = {
    import SearchRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchRecord
      .builder()
      .optionallyWith(trainingJob.map(value => value.buildAwsValue()))(
        _.trainingJob
      )
      .optionallyWith(experiment.map(value => value.buildAwsValue()))(
        _.experiment
      )
      .optionallyWith(trial.map(value => value.buildAwsValue()))(_.trial)
      .optionallyWith(trialComponent.map(value => value.buildAwsValue()))(
        _.trialComponent
      )
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(modelPackage.map(value => value.buildAwsValue()))(
        _.modelPackage
      )
      .optionallyWith(modelPackageGroup.map(value => value.buildAwsValue()))(
        _.modelPackageGroup
      )
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(pipelineExecution.map(value => value.buildAwsValue()))(
        _.pipelineExecution
      )
      .optionallyWith(featureGroup.map(value => value.buildAwsValue()))(
        _.featureGroup
      )
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchRecord.ReadOnly =
    zio.aws.sagemaker.model.SearchRecord.wrap(buildAwsValue())
}
object SearchRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchRecord =
      zio.aws.sagemaker.model.SearchRecord(
        trainingJob.map(value => value.asEditable),
        experiment.map(value => value.asEditable),
        trial.map(value => value.asEditable),
        trialComponent.map(value => value.asEditable),
        endpoint.map(value => value.asEditable),
        modelPackage.map(value => value.asEditable),
        modelPackageGroup.map(value => value.asEditable),
        pipeline.map(value => value.asEditable),
        pipelineExecution.map(value => value.asEditable),
        featureGroup.map(value => value.asEditable),
        project.map(value => value.asEditable)
      )
    def trainingJob: Optional[zio.aws.sagemaker.model.TrainingJob.ReadOnly]
    def experiment: Optional[zio.aws.sagemaker.model.Experiment.ReadOnly]
    def trial: Optional[zio.aws.sagemaker.model.Trial.ReadOnly]
    def trialComponent
        : Optional[zio.aws.sagemaker.model.TrialComponent.ReadOnly]
    def endpoint: Optional[zio.aws.sagemaker.model.Endpoint.ReadOnly]
    def modelPackage: Optional[zio.aws.sagemaker.model.ModelPackage.ReadOnly]
    def modelPackageGroup
        : Optional[zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly]
    def pipeline: Optional[zio.aws.sagemaker.model.Pipeline.ReadOnly]
    def pipelineExecution
        : Optional[zio.aws.sagemaker.model.PipelineExecution.ReadOnly]
    def featureGroup: Optional[zio.aws.sagemaker.model.FeatureGroup.ReadOnly]
    def project: Optional[zio.aws.sagemaker.model.Project.ReadOnly]
    def getTrainingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      AwsError.unwrapOptionField("trainingJob", trainingJob)
    def getExperiment
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Experiment.ReadOnly] =
      AwsError.unwrapOptionField("experiment", experiment)
    def getTrial: ZIO[Any, AwsError, zio.aws.sagemaker.model.Trial.ReadOnly] =
      AwsError.unwrapOptionField("trial", trial)
    def getTrialComponent
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialComponent.ReadOnly] =
      AwsError.unwrapOptionField("trialComponent", trialComponent)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getModelPackage
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackage.ReadOnly] =
      AwsError.unwrapOptionField("modelPackage", modelPackage)
    def getModelPackageGroup: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly
    ] = AwsError.unwrapOptionField("modelPackageGroup", modelPackageGroup)
    def getPipeline
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
    def getPipelineExecution: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineExecution.ReadOnly
    ] = AwsError.unwrapOptionField("pipelineExecution", pipelineExecution)
    def getFeatureGroup
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroup.ReadOnly] =
      AwsError.unwrapOptionField("featureGroup", featureGroup)
    def getProject
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ) extends zio.aws.sagemaker.model.SearchRecord.ReadOnly {
    override val trainingJob
        : Optional[zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJob())
        .map(value => zio.aws.sagemaker.model.TrainingJob.wrap(value))
    override val experiment
        : Optional[zio.aws.sagemaker.model.Experiment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experiment())
        .map(value => zio.aws.sagemaker.model.Experiment.wrap(value))
    override val trial: Optional[zio.aws.sagemaker.model.Trial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trial())
        .map(value => zio.aws.sagemaker.model.Trial.wrap(value))
    override val trialComponent
        : Optional[zio.aws.sagemaker.model.TrialComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponent())
        .map(value => zio.aws.sagemaker.model.TrialComponent.wrap(value))
    override val endpoint: Optional[zio.aws.sagemaker.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.sagemaker.model.Endpoint.wrap(value))
    override val modelPackage
        : Optional[zio.aws.sagemaker.model.ModelPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackage())
        .map(value => zio.aws.sagemaker.model.ModelPackage.wrap(value))
    override val modelPackageGroup
        : Optional[zio.aws.sagemaker.model.ModelPackageGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroup())
        .map(value => zio.aws.sagemaker.model.ModelPackageGroup.wrap(value))
    override val pipeline: Optional[zio.aws.sagemaker.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.sagemaker.model.Pipeline.wrap(value))
    override val pipelineExecution
        : Optional[zio.aws.sagemaker.model.PipelineExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecution())
        .map(value => zio.aws.sagemaker.model.PipelineExecution.wrap(value))
    override val featureGroup
        : Optional[zio.aws.sagemaker.model.FeatureGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroup())
        .map(value => zio.aws.sagemaker.model.FeatureGroup.wrap(value))
    override val project: Optional[zio.aws.sagemaker.model.Project.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.project())
        .map(value => zio.aws.sagemaker.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRecord
  ): zio.aws.sagemaker.model.SearchRecord.ReadOnly = new Wrapper(impl)
}
