package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RootAccess {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RootAccess
}
object RootAccess {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RootAccess
  ): zio.aws.sagemaker.model.RootAccess = value match {
    case software.amazon.awssdk.services.sagemaker.model.RootAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RootAccess.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.sagemaker.model.RootAccess.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.RootAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RootAccess =
      software.amazon.awssdk.services.sagemaker.model.RootAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.sagemaker.model.RootAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RootAccess =
      software.amazon.awssdk.services.sagemaker.model.RootAccess.ENABLED
  }
  case object Disabled extends zio.aws.sagemaker.model.RootAccess {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RootAccess =
      software.amazon.awssdk.services.sagemaker.model.RootAccess.DISABLED
  }
}
