package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ProjectEntityName,
  ProjectId,
  Timestamp,
  ProjectArn,
  EntityDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProjectSummary(
    projectName: ProjectEntityName,
    projectDescription: Optional[EntityDescription] = Optional.Absent,
    projectArn: ProjectArn,
    projectId: ProjectId,
    creationTime: Timestamp,
    projectStatus: zio.aws.sagemaker.model.ProjectStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProjectSummary = {
    import ProjectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProjectSummary
      .builder()
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .projectStatus(projectStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProjectSummary.ReadOnly =
    zio.aws.sagemaker.model.ProjectSummary.wrap(buildAwsValue())
}
object ProjectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProjectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProjectSummary =
      zio.aws.sagemaker.model.ProjectSummary(
        projectName,
        projectDescription.map(value => value),
        projectArn,
        projectId,
        creationTime,
        projectStatus
      )
    def projectName: ProjectEntityName
    def projectDescription: Optional[EntityDescription]
    def projectArn: ProjectArn
    def projectId: ProjectId
    def creationTime: Timestamp
    def projectStatus: zio.aws.sagemaker.model.ProjectStatus
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getProjectStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProjectStatus] =
      ZIO.succeed(projectStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProjectSummary
  ) extends zio.aws.sagemaker.model.ProjectSummary.ReadOnly {
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
    override val projectDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val projectArn: ProjectArn =
      zio.aws.sagemaker.model.primitives.ProjectArn(impl.projectArn())
    override val projectId: ProjectId =
      zio.aws.sagemaker.model.primitives.ProjectId(impl.projectId())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val projectStatus: zio.aws.sagemaker.model.ProjectStatus =
      zio.aws.sagemaker.model.ProjectStatus.wrap(impl.projectStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProjectSummary
  ): zio.aws.sagemaker.model.ProjectSummary.ReadOnly = new Wrapper(impl)
}
