package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelMetadataRequest(
    searchExpression: Optional[
      zio.aws.sagemaker.model.ModelMetadataSearchExpression
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest = {
    import ListModelMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
      .builder()
      .optionallyWith(searchExpression.map(value => value.buildAwsValue()))(
        _.searchExpression
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelMetadataRequest.wrap(buildAwsValue())
}
object ListModelMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelMetadataRequest =
      zio.aws.sagemaker.model.ListModelMetadataRequest(
        searchExpression.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def searchExpression: Optional[
      zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSearchExpression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly
    ] = AwsError.unwrapOptionField("searchExpression", searchExpression)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ) extends zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly {
    override val searchExpression: Optional[
      zio.aws.sagemaker.model.ModelMetadataSearchExpression.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.searchExpression())
      .map(value =>
        zio.aws.sagemaker.model.ModelMetadataSearchExpression.wrap(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest
  ): zio.aws.sagemaker.model.ListModelMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
