package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{TrialArn, TrialComponentArn}
import scala.jdk.CollectionConverters._
final case class DisassociateTrialComponentResponse(
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    trialArn: Optional[TrialArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse = {
    import DisassociateTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.DisassociateTrialComponentResponse
      .wrap(buildAwsValue())
}
object DisassociateTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DisassociateTrialComponentResponse =
      zio.aws.sagemaker.model.DisassociateTrialComponentResponse(
        trialComponentArn.map(value => value),
        trialArn.map(value => value)
      )
    def trialComponentArn: Optional[TrialComponentArn]
    def trialArn: Optional[TrialArn]
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse
  ) extends zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly {
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val trialArn: Optional[TrialArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse
  ): zio.aws.sagemaker.model.DisassociateTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
