package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.CodeRepositoryArn
import scala.jdk.CollectionConverters._
final case class UpdateCodeRepositoryResponse(
    codeRepositoryArn: CodeRepositoryArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse = {
    import UpdateCodeRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse
      .builder()
      .codeRepositoryArn(
        CodeRepositoryArn.unwrap(codeRepositoryArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.wrap(buildAwsValue())
}
object UpdateCodeRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateCodeRepositoryResponse =
      zio.aws.sagemaker.model.UpdateCodeRepositoryResponse(codeRepositoryArn)
    def codeRepositoryArn: CodeRepositoryArn
    def getCodeRepositoryArn: ZIO[Any, Nothing, CodeRepositoryArn] =
      ZIO.succeed(codeRepositoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse
  ) extends zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly {
    override val codeRepositoryArn: CodeRepositoryArn =
      zio.aws.sagemaker.model.primitives
        .CodeRepositoryArn(impl.codeRepositoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse
  ): zio.aws.sagemaker.model.UpdateCodeRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
