package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class ModelPackageValidationProfile(
    profileName: EntityName,
    transformJobDefinition: zio.aws.sagemaker.model.TransformJobDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile = {
    import ModelPackageValidationProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile
      .builder()
      .profileName(EntityName.unwrap(profileName): java.lang.String)
      .transformJobDefinition(transformJobDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageValidationProfile.wrap(buildAwsValue())
}
object ModelPackageValidationProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageValidationProfile =
      zio.aws.sagemaker.model.ModelPackageValidationProfile(
        profileName,
        transformJobDefinition.asEditable
      )
    def profileName: EntityName
    def transformJobDefinition
        : zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly
    def getProfileName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(profileName)
    def getTransformJobDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly
    ] = ZIO.succeed(transformJobDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile
  ) extends zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly {
    override val profileName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.profileName())
    override val transformJobDefinition
        : zio.aws.sagemaker.model.TransformJobDefinition.ReadOnly =
      zio.aws.sagemaker.model.TransformJobDefinition
        .wrap(impl.transformJobDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageValidationProfile
  ): zio.aws.sagemaker.model.ModelPackageValidationProfile.ReadOnly =
    new Wrapper(impl)
}
