package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListWorkteamsResponse(
    workteams: Iterable[zio.aws.sagemaker.model.Workteam],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse = {
    import ListWorkteamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse
      .builder()
      .workteams(workteams.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListWorkteamsResponse.wrap(buildAwsValue())
}
object ListWorkteamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListWorkteamsResponse =
      zio.aws.sagemaker.model.ListWorkteamsResponse(
        workteams.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def workteams: List[zio.aws.sagemaker.model.Workteam.ReadOnly]
    def nextToken: Optional[NextToken]
    def getWorkteams
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Workteam.ReadOnly]] =
      ZIO.succeed(workteams)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse
  ) extends zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly {
    override val workteams: List[zio.aws.sagemaker.model.Workteam.ReadOnly] =
      impl
        .workteams()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.Workteam.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse
  ): zio.aws.sagemaker.model.ListWorkteamsResponse.ReadOnly = new Wrapper(impl)
}
