package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineArn
import scala.jdk.CollectionConverters._
final case class DeletePipelineResponse(
    pipelineArn: Optional[PipelineArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse = {
    import DeletePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly =
    zio.aws.sagemaker.model.DeletePipelineResponse.wrap(buildAwsValue())
}
object DeletePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeletePipelineResponse =
      zio.aws.sagemaker.model
        .DeletePipelineResponse(pipelineArn.map(value => value))
    def pipelineArn: Optional[PipelineArn]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse
  ) extends zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly {
    override val pipelineArn: Optional[PipelineArn] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse
  ): zio.aws.sagemaker.model.DeletePipelineResponse.ReadOnly = new Wrapper(impl)
}
