package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{RoleArn, ModelName}
import scala.jdk.CollectionConverters._
final case class CreateModelRequest(
    modelName: ModelName,
    primaryContainer: Optional[zio.aws.sagemaker.model.ContainerDefinition] =
      Optional.Absent,
    containers: Optional[
      Iterable[zio.aws.sagemaker.model.ContainerDefinition]
    ] = Optional.Absent,
    inferenceExecutionConfig: Optional[
      zio.aws.sagemaker.model.InferenceExecutionConfig
    ] = Optional.Absent,
    executionRoleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(primaryContainer.map(value => value.buildAwsValue()))(
        _.primaryContainer
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        inferenceExecutionConfig.map(value => value.buildAwsValue())
      )(_.inferenceExecutionConfig)
      .executionRoleArn(RoleArn.unwrap(executionRoleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelRequest =
      zio.aws.sagemaker.model.CreateModelRequest(
        modelName,
        primaryContainer.map(value => value.asEditable),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferenceExecutionConfig.map(value => value.asEditable),
        executionRoleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        enableNetworkIsolation.map(value => value)
      )
    def modelName: ModelName
    def primaryContainer
        : Optional[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]
    def containers
        : Optional[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]]
    def inferenceExecutionConfig
        : Optional[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly]
    def executionRoleArn: RoleArn
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def enableNetworkIsolation: Optional[Boolean]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getPrimaryContainer: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("primaryContainer", primaryContainer)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getInferenceExecutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceExecutionConfig",
      inferenceExecutionConfig
    )
    def getExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ) extends zio.aws.sagemaker.model.CreateModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val primaryContainer
        : Optional[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryContainer())
        .map(value => zio.aws.sagemaker.model.ContainerDefinition.wrap(value))
    override val containers
        : Optional[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ContainerDefinition.wrap(item)
          }.toList
        )
    override val inferenceExecutionConfig
        : Optional[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceExecutionConfig())
        .map(value =>
          zio.aws.sagemaker.model.InferenceExecutionConfig.wrap(value)
        )
    override val executionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.executionRoleArn())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelRequest
  ): zio.aws.sagemaker.model.CreateModelRequest.ReadOnly = new Wrapper(impl)
}
