package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelPackageGroupArn
import scala.jdk.CollectionConverters._
final case class CreateModelPackageGroupResponse(
    modelPackageGroupArn: ModelPackageGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse = {
    import CreateModelPackageGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse
      .builder()
      .modelPackageGroupArn(
        ModelPackageGroupArn.unwrap(modelPackageGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelPackageGroupResponse
      .wrap(buildAwsValue())
}
object CreateModelPackageGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelPackageGroupResponse =
      zio.aws.sagemaker.model
        .CreateModelPackageGroupResponse(modelPackageGroupArn)
    def modelPackageGroupArn: ModelPackageGroupArn
    def getModelPackageGroupArn: ZIO[Any, Nothing, ModelPackageGroupArn] =
      ZIO.succeed(modelPackageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse
  ) extends zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly {
    override val modelPackageGroupArn: ModelPackageGroupArn =
      zio.aws.sagemaker.model.primitives
        .ModelPackageGroupArn(impl.modelPackageGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse
  ): zio.aws.sagemaker.model.CreateModelPackageGroupResponse.ReadOnly =
    new Wrapper(impl)
}
