package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AutoMLFailureReason
import scala.jdk.CollectionConverters._
final case class AutoMLPartialFailureReason(
    partialFailureMessage: Optional[AutoMLFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason = {
    import AutoMLPartialFailureReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason
      .builder()
      .optionallyWith(
        partialFailureMessage.map(value =>
          AutoMLFailureReason.unwrap(value): java.lang.String
        )
      )(_.partialFailureMessage)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly =
    zio.aws.sagemaker.model.AutoMLPartialFailureReason.wrap(buildAwsValue())
}
object AutoMLPartialFailureReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLPartialFailureReason =
      zio.aws.sagemaker.model
        .AutoMLPartialFailureReason(partialFailureMessage.map(value => value))
    def partialFailureMessage: Optional[AutoMLFailureReason]
    def getPartialFailureMessage: ZIO[Any, AwsError, AutoMLFailureReason] =
      AwsError.unwrapOptionField("partialFailureMessage", partialFailureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason
  ) extends zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly {
    override val partialFailureMessage: Optional[AutoMLFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partialFailureMessage())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AutoMLFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason
  ): zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly = new Wrapper(
    impl
  )
}
