package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{AttributeName, S3Uri}
import scala.jdk.CollectionConverters._
final case class S3DataSource(
    s3DataType: zio.aws.sagemaker.model.S3DataType,
    s3Uri: S3Uri,
    s3DataDistributionType: Optional[
      zio.aws.sagemaker.model.S3DataDistribution
    ] = Optional.Absent,
    attributeNames: Optional[Iterable[AttributeName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.S3DataSource = {
    import S3DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.S3DataSource
      .builder()
      .s3DataType(s3DataType.unwrap)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(s3DataDistributionType.map(value => value.unwrap))(
        _.s3DataDistributionType
      )
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributeNames)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.S3DataSource.ReadOnly =
    zio.aws.sagemaker.model.S3DataSource.wrap(buildAwsValue())
}
object S3DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.S3DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.S3DataSource =
      zio.aws.sagemaker.model.S3DataSource(
        s3DataType,
        s3Uri,
        s3DataDistributionType.map(value => value),
        attributeNames.map(value => value)
      )
    def s3DataType: zio.aws.sagemaker.model.S3DataType
    def s3Uri: S3Uri
    def s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.S3DataDistribution]
    def attributeNames: Optional[List[AttributeName]]
    def getS3DataType: ZIO[Any, Nothing, zio.aws.sagemaker.model.S3DataType] =
      ZIO.succeed(s3DataType)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getS3DataDistributionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.S3DataDistribution] =
      AwsError.unwrapOptionField(
        "s3DataDistributionType",
        s3DataDistributionType
      )
    def getAttributeNames: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.S3DataSource
  ) extends zio.aws.sagemaker.model.S3DataSource.ReadOnly {
    override val s3DataType: zio.aws.sagemaker.model.S3DataType =
      zio.aws.sagemaker.model.S3DataType.wrap(impl.s3DataType())
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val s3DataDistributionType
        : Optional[zio.aws.sagemaker.model.S3DataDistribution] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataDistributionType())
        .map(value => zio.aws.sagemaker.model.S3DataDistribution.wrap(value))
    override val attributeNames: Optional[List[AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.AttributeName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.S3DataSource
  ): zio.aws.sagemaker.model.S3DataSource.ReadOnly = new Wrapper(impl)
}
