package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ProcessingResources(
    clusterConfig: zio.aws.sagemaker.model.ProcessingClusterConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingResources = {
    import ProcessingResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingResources
      .builder()
      .clusterConfig(clusterConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingResources.ReadOnly =
    zio.aws.sagemaker.model.ProcessingResources.wrap(buildAwsValue())
}
object ProcessingResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingResources =
      zio.aws.sagemaker.model.ProcessingResources(clusterConfig.asEditable)
    def clusterConfig: zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly
    def getClusterConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly
    ] = ZIO.succeed(clusterConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingResources
  ) extends zio.aws.sagemaker.model.ProcessingResources.ReadOnly {
    override val clusterConfig
        : zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly =
      zio.aws.sagemaker.model.ProcessingClusterConfig.wrap(impl.clusterConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingResources
  ): zio.aws.sagemaker.model.ProcessingResources.ReadOnly = new Wrapper(impl)
}
