package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  Timestamp,
  MaxResults,
  SourceUri,
  String256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListContextsRequest(
    sourceUri: Optional[SourceUri] = Optional.Absent,
    contextType: Optional[String256] = Optional.Absent,
    createdAfter: Optional[Timestamp] = Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.SortContextsBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListContextsRequest = {
    import ListContextsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListContextsRequest
      .builder()
      .optionallyWith(
        sourceUri.map(value => SourceUri.unwrap(value): java.lang.String)
      )(_.sourceUri)
      .optionallyWith(
        contextType.map(value => String256.unwrap(value): java.lang.String)
      )(_.contextType)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListContextsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListContextsRequest.wrap(buildAwsValue())
}
object ListContextsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListContextsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListContextsRequest =
      zio.aws.sagemaker.model.ListContextsRequest(
        sourceUri.map(value => value),
        contextType.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sourceUri: Optional[SourceUri]
    def contextType: Optional[String256]
    def createdAfter: Optional[Timestamp]
    def createdBefore: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.SortContextsBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSourceUri: ZIO[Any, AwsError, SourceUri] =
      AwsError.unwrapOptionField("sourceUri", sourceUri)
    def getContextType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("contextType", contextType)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortContextsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListContextsRequest
  ) extends zio.aws.sagemaker.model.ListContextsRequest.ReadOnly {
    override val sourceUri: Optional[SourceUri] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceUri())
      .map(value => zio.aws.sagemaker.model.primitives.SourceUri(value))
    override val contextType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.contextType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.SortContextsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SortContextsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListContextsRequest
  ): zio.aws.sagemaker.model.ListContextsRequest.ReadOnly = new Wrapper(impl)
}
