package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait EdgePresetDeploymentStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus
}
object EdgePresetDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus
  ): zio.aws.sagemaker.model.EdgePresetDeploymentStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EdgePresetDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED
      extends zio.aws.sagemaker.model.EdgePresetDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.COMPLETED
  }
  case object FAILED
      extends zio.aws.sagemaker.model.EdgePresetDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentStatus.FAILED
  }
}
