package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ImageDisplayName,
  RoleArn,
  ImageDescription,
  Timestamp,
  FailureReason,
  ImageArn,
  ImageName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeImageResponse(
    creationTime: Optional[Timestamp] = Optional.Absent,
    description: Optional[ImageDescription] = Optional.Absent,
    displayName: Optional[ImageDisplayName] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    imageArn: Optional[ImageArn] = Optional.Absent,
    imageName: Optional[ImageName] = Optional.Absent,
    imageStatus: Optional[zio.aws.sagemaker.model.ImageStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse = {
    import DescribeImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
      .builder()
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value =>
          ImageDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        displayName.map(value =>
          ImageDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        imageName.map(value => ImageName.unwrap(value): java.lang.String)
      )(_.imageName)
      .optionallyWith(imageStatus.map(value => value.unwrap))(_.imageStatus)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageResponse.wrap(buildAwsValue())
}
object DescribeImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageResponse =
      zio.aws.sagemaker.model.DescribeImageResponse(
        creationTime.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        failureReason.map(value => value),
        imageArn.map(value => value),
        imageName.map(value => value),
        imageStatus.map(value => value),
        lastModifiedTime.map(value => value),
        roleArn.map(value => value)
      )
    def creationTime: Optional[Timestamp]
    def description: Optional[ImageDescription]
    def displayName: Optional[ImageDisplayName]
    def failureReason: Optional[FailureReason]
    def imageArn: Optional[ImageArn]
    def imageName: Optional[ImageName]
    def imageStatus: Optional[zio.aws.sagemaker.model.ImageStatus]
    def lastModifiedTime: Optional[Timestamp]
    def roleArn: Optional[RoleArn]
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, ImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, ImageDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getImageName: ZIO[Any, AwsError, ImageName] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageStatus] =
      AwsError.unwrapOptionField("imageStatus", imageStatus)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ) extends zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly {
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val description: Optional[ImageDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDescription(value))
    override val displayName: Optional[ImageDisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDisplayName(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: Optional[ImageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
    override val imageName: Optional[ImageName] = zio.aws.core.internal
      .optionalFromNullable(impl.imageName())
      .map(value => zio.aws.sagemaker.model.primitives.ImageName(value))
    override val imageStatus: Optional[zio.aws.sagemaker.model.ImageStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageStatus())
        .map(value => zio.aws.sagemaker.model.ImageStatus.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse
  ): zio.aws.sagemaker.model.DescribeImageResponse.ReadOnly = new Wrapper(impl)
}
