package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FeatureGroupArn
import scala.jdk.CollectionConverters._
final case class CreateFeatureGroupResponse(featureGroupArn: FeatureGroupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse = {
    import CreateFeatureGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse
      .builder()
      .featureGroupArn(
        FeatureGroupArn.unwrap(featureGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateFeatureGroupResponse.wrap(buildAwsValue())
}
object CreateFeatureGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateFeatureGroupResponse =
      zio.aws.sagemaker.model.CreateFeatureGroupResponse(featureGroupArn)
    def featureGroupArn: FeatureGroupArn
    def getFeatureGroupArn: ZIO[Any, Nothing, FeatureGroupArn] =
      ZIO.succeed(featureGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse
  ) extends zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly {
    override val featureGroupArn: FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn(impl.featureGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse
  ): zio.aws.sagemaker.model.CreateFeatureGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
