package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ResponseMIMEType,
  ContentType,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class AdditionalInferenceSpecificationDefinition(
    name: EntityName,
    description: Optional[EntityDescription] = Optional.Absent,
    containers: Iterable[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition
    ],
    supportedTransformInstanceTypes: Optional[
      Iterable[zio.aws.sagemaker.model.TransformInstanceType]
    ] = Optional.Absent,
    supportedRealtimeInferenceInstanceTypes: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    ] = Optional.Absent,
    supportedContentTypes: Optional[Iterable[ContentType]] = Optional.Absent,
    supportedResponseMIMETypes: Optional[Iterable[ResponseMIMEType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition = {
    import AdditionalInferenceSpecificationDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .containers(containers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        supportedTransformInstanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedTransformInstanceTypesWithStrings)
      .optionallyWith(
        supportedRealtimeInferenceInstanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedRealtimeInferenceInstanceTypesWithStrings)
      .optionallyWith(
        supportedContentTypes.map(value =>
          value.map { item =>
            ContentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedContentTypes)
      .optionallyWith(
        supportedResponseMIMETypes.map(value =>
          value.map { item =>
            ResponseMIMEType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedResponseMIMETypes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly =
    zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
      .wrap(buildAwsValue())
}
object AdditionalInferenceSpecificationDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition =
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition(
        name,
        description.map(value => value),
        containers.map { item =>
          item.asEditable
        },
        supportedTransformInstanceTypes.map(value => value),
        supportedRealtimeInferenceInstanceTypes.map(value => value),
        supportedContentTypes.map(value => value),
        supportedResponseMIMETypes.map(value => value)
      )
    def name: EntityName
    def description: Optional[EntityDescription]
    def containers
        : List[zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly]
    def supportedTransformInstanceTypes
        : Optional[List[zio.aws.sagemaker.model.TransformInstanceType]]
    def supportedRealtimeInferenceInstanceTypes
        : Optional[List[zio.aws.sagemaker.model.ProductionVariantInstanceType]]
    def supportedContentTypes: Optional[List[ContentType]]
    def supportedResponseMIMETypes: Optional[List[ResponseMIMEType]]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContainers: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly
    ]] = ZIO.succeed(containers)
    def getSupportedTransformInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TransformInstanceType
    ]] = AwsError.unwrapOptionField(
      "supportedTransformInstanceTypes",
      supportedTransformInstanceTypes
    )
    def getSupportedRealtimeInferenceInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ]] = AwsError.unwrapOptionField(
      "supportedRealtimeInferenceInstanceTypes",
      supportedRealtimeInferenceInstanceTypes
    )
    def getSupportedContentTypes: ZIO[Any, AwsError, List[ContentType]] =
      AwsError.unwrapOptionField("supportedContentTypes", supportedContentTypes)
    def getSupportedResponseMIMETypes
        : ZIO[Any, AwsError, List[ResponseMIMEType]] =
      AwsError.unwrapOptionField(
        "supportedResponseMIMETypes",
        supportedResponseMIMETypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition
  ) extends zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly {
    override val name: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.name())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val containers: List[
      zio.aws.sagemaker.model.ModelPackageContainerDefinition.ReadOnly
    ] = impl
      .containers()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelPackageContainerDefinition.wrap(item)
      }
      .toList
    override val supportedTransformInstanceTypes
        : Optional[List[zio.aws.sagemaker.model.TransformInstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTransformInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.TransformInstanceType.wrap(item)
          }.toList
        )
    override val supportedRealtimeInferenceInstanceTypes: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedRealtimeInferenceInstanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(item)
        }.toList
      )
    override val supportedContentTypes: Optional[List[ContentType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedContentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ContentType(item)
          }.toList
        )
    override val supportedResponseMIMETypes: Optional[List[ResponseMIMEType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedResponseMIMETypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ResponseMIMEType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition
  ): zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly =
    new Wrapper(impl)
}
