package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TargetObjectiveMetricValue
import scala.jdk.CollectionConverters._
final case class TuningJobCompletionCriteria(
    targetObjectiveMetricValue: TargetObjectiveMetricValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria = {
    import TuningJobCompletionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
      .builder()
      .targetObjectiveMetricValue(
        TargetObjectiveMetricValue.unwrap(
          targetObjectiveMetricValue
        ): java.lang.Float
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly =
    zio.aws.sagemaker.model.TuningJobCompletionCriteria.wrap(buildAwsValue())
}
object TuningJobCompletionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TuningJobCompletionCriteria =
      zio.aws.sagemaker.model
        .TuningJobCompletionCriteria(targetObjectiveMetricValue)
    def targetObjectiveMetricValue: TargetObjectiveMetricValue
    def getTargetObjectiveMetricValue
        : ZIO[Any, Nothing, TargetObjectiveMetricValue] =
      ZIO.succeed(targetObjectiveMetricValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ) extends zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly {
    override val targetObjectiveMetricValue: TargetObjectiveMetricValue =
      zio.aws.sagemaker.model.primitives
        .TargetObjectiveMetricValue(impl.targetObjectiveMetricValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ): zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly = new Wrapper(
    impl
  )
}
